#include <iostream>
#include <vector>
#include <queue>
using namespace std;

const int MAX_N = 500001;
const int INF = 1e9;

int jumps[MAX_N];
vector<int> rooms[MAX_N];

void findMinimumJumps(int N, int platform[], int change[]) {
    jumps[1] = 0;
    queue<int> q;
    q.push(1);

    while (!q.empty()) {
        int current = q.front();
        q.pop();

        for (int next_room : rooms[current]) {
            if (jumps[next_room] > jumps[current] + 1) {
                jumps[next_room] = jumps[current] + 1;
                q.push(next_room);
            }
        }

        if (platform[current] && jumps[current] < jumps.size()) {
            jumps[current] = 0;
            q.push(current);
        }

        if (change[current]) {
            if (jumps[current] + 1 < jumps.size() && jumps[current] + 1 < jumps[change[current]]) {
                jumps[change[current]] = jumps[current] + 1;
                q.push(change[current]);
            }
        }
    }
}

int main() {
    int N;
    cin >> N;

    int platform[MAX_N];
    int change[MAX_N];

    for (int i = 1; i < N; ++i) {
        int U, V;
        cin >> U >> V;
        rooms[U].push_back(V);
        rooms[V].push_back(U);
    }

    for (int i = 1; i <= N; ++i) {
        cin >> platform[i];
        jumps[i] = INF;
    }

    for (int i = 1; i <= N; ++i) {
        cin >> change[i];
    }

    findMinimumJumps(N, platform, change);

    for (int i = 1; i <= N; ++i) {
        if (jumps[i] == INF) {
            cout << "-1 ";
        } else {
            cout << jumps[i] << " ";
        }
    }
    cout << endl;

    return 0;
}